.ifndef __CONSTANTS__
.define __CONSTANTS__

.define VdpControlPort $bf
.define VdpStatusPort $bf
.define VdpDataPort $be
.define VdpLineCounter $7e

.define VdpMisc1 $80
.define VdpMisc2 $81
.define VdpNameTable $82
.define VdpColorTable $83
.define VdpPatternTable $84
.define VdpSpriteAttrTable $85
.define VdpSpritePattTable $86
.define VdpBackgroundColor $87
.define VdpHorizontalScroll $88
.define VdpVerticalScroll $89

.define M1VerticalScrollLock 1<<7
.define M1HorizontalScrollLock 1<<6
.define M1HideLeftColoum 1<<5
.define M1LineInterrupts 1<<4
.define M1ShiftSprites 1<<3
.define M1Mode4 1<<2
.define	M1ExtendedHeightEnable 1<<1
.define M1Synch 1

.define BitM1VerticalScrollLock 7
.define BitM1HorizontalScrollLock 6
.define BitM1HideLeftColoum 5
.define BitM1LineInterrupts 4
.define BitM1ShiftSprites 3
.define BitM1Mode4 2
.define	BitM1ExtendedHeightEnable 1
.define BitM1Synch 0

.define M2DisplayEnabled 1<<6
.define M2FrameInterrupts 1<<5
.define M2Extended224 1<<4
.define M2Extended240 1<<3
.define M2DoubleTiledSprites 1<<1
.define M2DoubleSizedSprites 1

.define BitM2DisplayEnabled 6
.define BitM2FrameInterrupts 5
.define BitM2Extended224 4
.define BitM2Extended240 3
.define BitM2DoubleTiledSprites 1
.define BitM2DoubleSizedSprites 0

.define CramWrite.hi $c0
.define CramWrite $c000
.define VramWrite.hi $40
.define VramWrite $4000
.define VramSpriteTable $3f00
.define VramSpriteTable.hi $3f
.define VramSpriteTableBottom.lo $80
.define VramRowCount 28
.define VramColumnCount 32

.define Th.hi $F5
.define Th.lo $D5

;SACBRLDU
.define StartKey 1<<7
.define AKey 1<<6
.define CKey 1<<5
.define BKey 1<<4
.define RKey 1<<3
.define LKey 1<<2
.define DKey 1<<1
.define UKey 1

;SACBRLDU
.define BitStartKey 7
.define BitAKey 6
.define BitCKey 5
.define BitBKey 4
.define BitRKey 3
.define BitLKey 2
.define BitDKey 1
.define BitUKey 0


;SZ5H3VNC: flag register, just in case we need those flags on other register than f
.define SF 1 << 7
.define ZF 1 << 6
.define B5F 1 << 5
.define HCF 1 << 4
.define B3F 1 << 3
.define OPF 1 << 2
.define NF 1 << 1
.define CF 1 

;Bosses
.define BubbleMan 1
.define AirMan 1 << 1
.define QuickMan 1 << 2
.define HeatMan 1 << 3
.define WoodMan 1 << 4
.define MetalMan 1 << 5
.define FlashMan 1 << 6
.define CrashMan 1 << 7
 
;ItensToBosses
.define Item1Boss HeatMan
.define Item2Boss AirMan
.define Item3Boss FlashMan

;Name table entry flags
.define SpritePalette 1 << 3
.define SpritesBelow 1 << 4

.define MegamanFrameTileCount 17
.define MegamanMaxFrameSize MegamanFrameTileCount*32

.define MapperConfig $fffc
.define MapperSlot0 $fffd
.define MapperSlot1 $fffe
.define MapperSlot2 $ffff
.define MapperSlot2Read $dfff

.define SpaceTile $0198

.define CheckpointFlag 1<<7
.define LoadNewPaletteFlag 1<<6
.define BeginningTransitionsFlag 1<<5
.define EndingTransitionsFlag 1<<4
.define LoadGameplayMapFlag 1<<3
.define LoagTilesFlag 1<<2

.define TransitB %001
.define TransitT %010
.define TransitR %100
.define TransitBT %011
.define TransitBR %101
.define TransitTR %110
.define TransitBTR %111

;Orientations
.define OrientationVert %10000000
.define OrientationHor %01000000
.define OrientationFoward 0
.define OrientationBackward 1

.define PaletteNewAddressMark %01000000
.define PaletteEndingMark %11000000
.define PaletteAnimationMark %10000000
.define PaletteAnimationCancel %10000000
.define PaletteAnimationEndMark $ff

;Megaman specs
.define MegamanWalkingSpeed $0160


.endif